<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\PKD;
use Gedmo\Tree\Entity\Repository\NestedTreeRepository;

/**
 * PKDRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PKDRepository extends NestedTreeRepository
{
    /**
     * add new ContributionZUS
     *
     * @param $data
     * @param bool $flush
     * @return PKD
     */
    public function add($data, $flush = false)
    {
        $PKD = new PKD();

        $PKD->setTitle($data['Name']);
        $PKD->setSymbol($data['Symbol']);
        if(isset($data['Parent']) && $data['Parent'] != null)
        {
            $PKD->setParent($data['Parent']);
        }

        $this->getEntityManager()->persist($PKD);
        if($flush)
        {
            $this->getEntityManager()->flush();
            $this->getEntityManager()->refresh($data['Parent']);
        }

        return $PKD;
    }
}
